/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import org.codefilarete.stalactite.engine.runtime.WriteExecutor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;

public class DeleteExecutor<C, I, T extends Table<T>>
extends WriteExecutor<C, I, T>
implements org.codefilarete.stalactite.engine.DeleteExecutor<C, I> {
    private SQLOperation.SQLOperationListener<Column<T, ?>> operationListener;

    public DeleteExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        super(mappingStrategy, connectionConfiguration, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
    }

    public void setOperationListener(SQLOperation.SQLOperationListener<Column<T, ?>> listener) {
        this.operationListener = listener;
    }

    @Override
    public void delete(Iterable<? extends C> entities) {
        ColumnParameterizedSQL deleteStatement = this.getDmlGenerator().buildDelete(this.getMapping().getTargetTable(), this.getMapping().getVersionedKeys());
        List entitiesCopy = Iterables.copy(entities);
        WriteOperationFactory.ExpectedBatchedRowCountsSupplier expectedBatchedRowCountsSupplier = new WriteOperationFactory.ExpectedBatchedRowCountsSupplier(entitiesCopy.size(), this.getBatchSize());
        WriteOperation<Column<T, ?>> writeOperation = this.newWriteOperation((SQLStatement<Column<T, ?>>)deleteStatement, this.getConnectionProvider(), expectedBatchedRowCountsSupplier);
        WriteExecutor.JDBCBatchingIterator jdbcBatchingIterator = new WriteExecutor.JDBCBatchingIterator(entitiesCopy, writeOperation, this.getBatchSize());
        jdbcBatchingIterator.forEachRemaining(c -> writeOperation.addBatch(this.getMapping().getVersionedKeyValues(c)));
    }

    private WriteOperation<Column<T, ?>> newWriteOperation(SQLStatement<Column<T, ?>> statement, ConnectionProvider currentConnectionProvider, LongSupplier expectedRowCount) {
        WriteOperation<Column<T, ?>> writeOperation = this.getWriteOperationFactory().createInstance(statement, currentConnectionProvider, expectedRowCount);
        writeOperation.setListener(this.operationListener);
        return writeOperation;
    }

    private WriteOperation<Column<T, ?>> newWriteOperation(SQLStatement<Column<T, ?>> statement, ConnectionProvider currentConnectionProvider, long expectedRowCount) {
        WriteOperation<Column<T, ?>> writeOperation = this.getWriteOperationFactory().createInstance(statement, currentConnectionProvider, expectedRowCount);
        writeOperation.setListener(this.operationListener);
        return writeOperation;
    }

    @Override
    public void deleteById(Iterable<? extends C> entities) {
        Set ids = (Set)Iterables.collect(entities, this.getMapping()::getId, HashSet::new);
        this.deleteFromId(ids);
    }

    public void deleteFromId(Iterable<I> ids) {
        int blockSize = this.getInOperatorMaxSize();
        List parcels = Iterables.chunk(ids, (int)blockSize);
        if (parcels.isEmpty()) {
            return;
        }
        List lastBlock = (List)Iterables.last((List)parcels, Collections.emptyList());
        if (lastBlock.size() == blockSize) {
            lastBlock = Collections.emptyList();
        } else {
            parcels = Iterables.cutTail((List)parcels);
        }
        ConnectionProvider currentConnectionProvider = this.getConnectionProvider();
        Object targetTable = this.getMapping().getTargetTable();
        KeepOrderSet pkColumns = ((Table)targetTable).getPrimaryKey().getColumns();
        IdentifierAssembler identifierAssembler = this.getMapping().getIdMapping().getIdentifierAssembler();
        if (!parcels.isEmpty()) {
            this.processFullSizedBlocks(parcels, currentConnectionProvider, targetTable, (Set<Column<T, ?>>)pkColumns, identifierAssembler, blockSize);
        }
        if (!lastBlock.isEmpty()) {
            this.processPartialBlock(lastBlock, currentConnectionProvider, targetTable, (Set<Column<T, ?>>)pkColumns, identifierAssembler);
        }
    }

    private void processFullSizedBlocks(List<List<I>> parcels, ConnectionProvider connectionProvider, T targetTable, Set<Column<T, ?>> pkColumns, IdentifierAssembler<I, T> identifierAssembler, int blockSize) {
        ColumnParameterizedSQL<T> deleteStatement = this.getDmlGenerator().buildDeleteByKey(targetTable, pkColumns, blockSize);
        try (WriteOperation writeOperation = this.newWriteOperation((SQLStatement<Column<T, ?>>)deleteStatement, connectionProvider, blockSize);){
            WriteExecutor.JDBCBatchingIterator<List<I>> jdbcBatchingIterator = new WriteExecutor.JDBCBatchingIterator<List<I>>(parcels, writeOperation, this.getBatchSize());
            HashMap pkValues = new HashMap();
            pkColumns.forEach(c -> {
                List cfr_ignored_0 = pkValues.put(c, new ArrayList());
            });
            jdbcBatchingIterator.forEachRemaining(deleteKeys -> {
                pkValues.values().forEach(Collection::clear);
                deleteKeys.forEach(id -> identifierAssembler.getColumnValues(id).forEach((c, v) -> ((List)pkValues.get(c)).add(v)));
                writeOperation.addBatch(pkValues);
            });
        }
    }

    private void processPartialBlock(List<I> lastBlock, ConnectionProvider connectionProvider, T targetTable, Set<Column<T, ?>> pkColumns, IdentifierAssembler<I, T> identifierAssembler) {
        ColumnParameterizedSQL<T> deleteStatement = this.getDmlGenerator().buildDeleteByKey(targetTable, pkColumns, lastBlock.size());
        try (WriteOperation<Column<T, ?>> writeOperation = this.newWriteOperation((SQLStatement<Column<T, ?>>)deleteStatement, connectionProvider, lastBlock.size());){
            if (lastBlock.size() == 1) {
                writeOperation.setValues(identifierAssembler.getColumnValues(lastBlock.get(0)));
            } else {
                HashMap pkValues = new HashMap();
                lastBlock.forEach(id -> {
                    Map localPkValues = identifierAssembler.getColumnValues(id);
                    pkColumns.forEach(pkColumn -> pkValues.computeIfAbsent(pkColumn, k -> new ArrayList()).add(localPkValues.get(pkColumn)));
                });
                writeOperation.setValues(pkValues);
            }
            writeOperation.execute();
        }
    }
}

